<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Client extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'email',
        'phone',
        'address',
        'notes',
    ];

    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    public function measurements()
    {
        return $this->hasMany(Measurement::class);
    }

    public function invoices()
    {
        return $this->hasMany(Invoice::class);
    }
} 