<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('order_materials', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->onDelete('cascade');
            $table->foreignId('material_id')->constrained()->onDelete('cascade');
            $table->integer('quantity_used');
            $table->decimal('cost', 10, 2);
            $table->timestamps();
            
            $table->unique(['order_id', 'material_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('order_materials');
    }
}; 